<%@page contentType="text/html;charset=utf-8"%>
<!DOCTYPE html>
<html xmlns="http://www.w3.org/1999/xhtml" lang="ko" xml:lang="ko">
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
	<meta http-equiv="Content-Script-Type" content="text/javascript" />
	<meta http-equiv="Content-Style-Type" content="text/css" />
	<meta http-equiv="X-UA-Compatible" content="IE=edge" />

	<script type="text/javascript" src="../Chart/jquery-1.7.2.min.js" ></script>

	<script type="text/javascript" src="../js/common.js"></script>

	<script type="text/javascript" src="../Chart/highcharts/highcharts.js"></script>
	<script type="text/javascript" src="../Chart/ibchart.js"></script>
	<script type="text/javascript" src="../Chart/ibchartinfo.js"></script>


	<link href="../Sheet/js/css/default/main.css" rel="stylesheet"/>
	<script type="text/javascript" src="../Sheet/js/locale/ko.js"></script>
	<script type="text/javascript" src="../Sheet/js/plugins/ibsheet-common.js"></script>
	<script type="text/javascript" src="../Sheet/js/ibsheet.js"></script>
	<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
	<title>Insert title here</title>
</head>
<script>
	$(document).ready(function(){
		initSheet();
	});
	function initSheet(){
		var initSheet ={
			Cfg : {SearchMode:0},
			Cols :[
						{Header:"이름",			Type:"Text",    	Name:"uName",		Width:80, 	 		Align:"Center"},
						{Header:"국어",			Type:"Text",    	Name:"KOR",		Width:80, 	 		Align:"Center"},
						{Header:"영어",			Type:"Text",    	Name:"ENG",		Width:80, 	  		Align:"Center"},
						{Header:"수학",			Type:"Text",    	Name:"MATH",		Width:80, 	  		Align:"Center"}
				]
		};
		IBSheet.create({
			id:"mySheet",
			el:"sheetDiv",
			options:initSheet,
			data:[
				{"uName":"홍길동","KOR":80,"ENG":90,"MATH":70},
				{"uName":"이순신","KOR":95,"ENG":66,"MATH":50},
				{"uName":"허균","KOR":70,"ENG":60,"MATH":100},
			]
		})

	}
	function mySheet_OnSearchEnd(){
		show();
	}
	function chartInit(){
		//차트의 모든 속성 설정
		myChart.setOptions({
			//1. 제목
			title:{
				text:"대 제목 입니다."
// 				,align:"center" //가로정렬(left,right,center)
// 				,verticalAlign:"top"//상하정렬(top,middle,bottom)
// 				,floating:false//플로팅여부(true로 설정시 다른 객체와 겹쳐질수 있음)
				,style:{ //글자 스타일(css형식)
					color:"#6655FF"
					,fontWeight:700
				}
			}

			//2. 부제목
			,subTitle:{							//myChart.SetSubtitleOptions();
				text:"부 제목 입니다."
// 				,align:"center" //left,right,center
// 				,verticalAlign:"top"//top,middle,bottom
// 				,floating:false
			}
			//3. 차트 종류,크기 설정
			,chart:{
				type:"column"//차트유형(line,spline,pie,bar,area,scatter)
				,backgroundColor:"#EDEDED" //차트 전체 배경색
				,plotBackgroundColor:"#ADADAD" //Plot 영역에 대한 배경색
				,zoomType:"y" //확대기능 사용 축 (x,y,xy)
			}
			//4. 범례영역 지정
			,legend:{								//myChart.SetLegendOptions();
				align:"right" //가로정렬(left,right,center)
				,verticalAlign:"middle"//상하정렬(top,middle,bottom)
				,layout:"vertical"//가로,세로 정렬(vertical,horizontal)

			}
			//5. 차트의 색상 지정

			,colors:[		//시리즈 색상 변경
				"#C4EF67","#FEF07F","#FEAD49","#E3C3F1","#93ECFF","#82B6FF","#C0C4FF","#FDBFFE","#FEC67B","#5EE93A","#FD7162","#D4B6A5","#80D6DA"
			]

			//6. 각 차트별 특성 지정 SetPlotOptions
			,plotOptions : {						//myChart.SetPlotOptions();
				//컬럼차트 및 바차트 속성
				/*
				column : {		//또는 Bar
					borderColor: "#000000"			//테두리의 색상 설정
					,borderRadius: 0				//테두리 모서리의 둥근 정도 설정(1,2,3....)
					,borderWidth: 1					//테두리의 넓이 설정
					//차트 데이타 라벨 설정
					,dataLabels: {
						enabled:true						//데이타 라벨 사용여부
						//,align:"center"					//정렬 설정 ( left, center, right )
						//,backgroundColor: "#ffffff"		//배경색상 설정
						//,borderColor: "#000000"			//테두리 색상
						//,borderRadius: 2					//테두리 둥근 정도
						//,borderWidth: 1					//테두리의 굵기
						//,color: "#000000"					//데이타 라벨 텍스트 색상
						//,crop:false						//데이타 라벨이 차트 영역 밖으로 나갔을때 자를지 여부( overflow가 none 인 경우 )
						//,format: "{y} 개"					//라벨 포멧 설정
						//,formatter: function(){			//함수로 포멧 설정
						//	return this.x + ">" + this.y;
						//}
						//,overflow:"justify"					//영역을 넘었을 때의 데이타 라벨 처리여부 justify(차트영역으로 내림 default), none(아무것도 안함)
						//,rotation: 0							//데이타 라벨 텍스트 회전
						//,style: {								//데이타 라벨 텍스트의 css 속성부여
						//	fontWeight:"bold"
						//	,color:"#1f1f1f"
						//}
						//,x: 0									//데이타 라벨 x축 이동
						//,y: -6								//데이타 라벨 y축 이동
						//,zIndex: 6							//데이타 라벨 zindex
					}
					,groupPadding: 0.2					//그룹간격
					,negativeColor: "blue"				//음수일때 색상
					//,pointPadding: 0.1					//포인트 간격
					//,pointWidth: null						//포인트 넓이
					//,showInLegend: true					//범례 표시 여부
					//,stacking: null					//차트 스택킹 null, normal, percent
					//,visible: true					//숨김여부
				}*/

				//라인차트 및 스플라인 속성
				/*
				line:{	//또는 Spline(Step 속성 제외)
					connectNulls:true						//값이 null 인경우 연결 여부
					,dashStyle:"solid"						//선유형 "solid,shortDash,shortDot,shortDashDot,shortDashDotDot,dot,dash,longDash,dashDot,longDashDot,longDashDotDot"
					//차트 데이타 라벨 설정
					,dataLabels: {
						enabled:true						//데이타 라벨 사용여부
						//,align:"center"					//정렬 설정 ( left, center, right )
						//,backgroundColor: "#ffffff"		//배경색상 설정
						//,borderColor: "#000000"			//테두리 색상
						//,borderRadius: 2					//테두리 둥근 정도
						//,borderWidth: 1					//테두리의 굵기
						//,color: "#000000"					//데이타 라벨 텍스트 색상
						//,crop:false						//데이타 라벨이 차트 영역 밖으로 나갔을때 자를지 여부( overflow가 none 인 경우 )
						//,format: "{y} 개"					//라벨 포멧 설정
						//,formatter: function(){			//함수로 포멧 설정
						//	return this.x + ">" + this.y;
						//}
						//,overflow:"justify"					//영역을 넘었을 때의 데이타 라벨 처리여부 justify(차트영역으로 내림 default), none(아무것도 안함)
						//,rotation: 0							//데이타 라벨 텍스트 회전
						//,style: {								//데이타 라벨 텍스트의 css 속성부여
						//	fontWeight:"bold"
						//	,color:"#1f1f1f"
						//}
						//,x: 0									//데이타 라벨 x축 이동
						//,y: -6								//데이타 라벨 y축 이동
						//,zIndex: 6							//데이타 라벨 zindex
					}
					//,lineWidth:2						//라인 넓이
					//,marker : {							//Marker
					//	enabled : true
					//	,symbol : "circle"				//"circle", "square", "diamond", "triangle" and "triangle-down"
					//}
					//,negativeColor: "blue"				//음수일때 색상
					//,step : false							//라인 계단형 여부
					//,showInLegend: true					//범례 표시 여부
					//,stacking: null					//차트 스택킹 null, normal, percent
					//,visible: true					//숨김여부
				}*/

				//영역차트 속성
				/*
				area :{
					connectNulls:true						//값이 null 인경우 연결 여부
					//,color : "#ffffff"					//색상 설정
					//,dashStyle:"solid"					//선유형 "solid,shortDash,shortDot,shortDashDot,shortDashDotDot,dot,dash,longDash,dashDot,longDashDot,longDashDotDot"
					//차트 데이타 라벨 설정
					,dataLabels: {
						enabled:true						//데이타 라벨 사용여부
						//,align:"center"					//정렬 설정 ( left, center, right )
						//,backgroundColor: "#ffffff"		//배경색상 설정
						//,borderColor: "#000000"			//테두리 색상
						//,borderRadius: 2					//테두리 둥근 정도
						//,borderWidth: 1					//테두리의 굵기
						//,color: "#000000"					//데이타 라벨 텍스트 색상
						//,crop:false						//데이타 라벨이 차트 영역 밖으로 나갔을때 자를지 여부( overflow가 none 인 경우 )
						//,format: "{y} 개"					//라벨 포멧 설정
						//,formatter: function(){			//함수로 포멧 설정
						//	return this.x + ">" + this.y;
						//}
						//,overflow:"justify"					//영역을 넘었을 때의 데이타 라벨 처리여부 justify(차트영역으로 내림 default), none(아무것도 안함)
						//,rotation: 0							//데이타 라벨 텍스트 회전
						//,style: {								//데이타 라벨 텍스트의 css 속성부여
						//	fontWeight:"bold"
						//	,color:"#1f1f1f"
						//}
						//,x: 0									//데이타 라벨 x축 이동
						//,y: -6								//데이타 라벨 y축 이동
						//,zIndex: 6							//데이타 라벨 zindex
					}
					//,fillColor : "#a1a1a1"            //영역 색상
					//,lineWidth:2						//라인 넓이
					//,marker : {							//Marker
					//	enabled : true
					//	,symbol : "circle"				//"circle", "square", "diamond", "triangle" and "triangle-down"
					//}
					//,negativeColor: "blue"				//음수일때 색상
					//,negativeFillColor : "blue"			//음수일때 채우는 색상
					//,step : false							//라인 계단형 여부
					//,showInLegend: true					//범례 표시 여부
					//,stacking: null					//차트 스택킹 null, normal, percent
					//,visible: true					//숨김여부
				}
				*/
				//파이차트 속성
				/*
				pie:{
					borderColor: "#000000"			//테두리의 색상 설정
					//,borderWidth: 1					//테두리의 넓이 설정
					//,center:[null, null]			//파이차트의 위치(x,y)
					//,colors : ["#ffffff","#aaaaaa","#777777","#222222"]	//array 형식으로 색상 설정
					//차트 데이타 라벨 설정
					,dataLabels: {
						enabled:true						//데이타 라벨 사용여부
						//,align:"center"					//정렬 설정 ( left, center, right )
						//,backgroundColor: "#ffffff"		//배경색상 설정
						//,borderColor: "#000000"			//테두리 색상
						//,borderRadius: 2					//테두리 둥근 정도
						//,borderWidth: 1					//테두리의 굵기
						//,color: "#000000"					//데이타 라벨 텍스트 색상
						//,crop:false						//데이타 라벨이 차트 영역 밖으로 나갔을때 자를지 여부( overflow가 none 인 경우 )
						//,format: "{y} 개"					//라벨 포멧 설정
						//,formatter: function(){			//함수로 포멧 설정
						//	return this.x + ">" + this.y;
						//}
						//,overflow:"justify"					//영역을 넘었을 때의 데이타 라벨 처리여부 justify(차트영역으로 내림 default), none(아무것도 안함)
						//,rotation: 0							//데이타 라벨 텍스트 회전
						//,style: {								//데이타 라벨 텍스트의 css 속성부여
						//	fontWeight:"bold"
						//	,color:"#1f1f1f"
						//}
						//,x: 0									//데이타 라벨 x축 이동
						//,y: -6								//데이타 라벨 y축 이동
						//,zIndex: 6							//데이타 라벨 zindex
					}
					//,endAngle:320				//파이의 마지막 각도
					//,startAngle:20				//파이의 시작 각도
					//,innerSize : 50						//파이차트 속의 빈영역 크기 설정
					//,showInLegend: true					//범례 표시 여부
					//,visible: true					//숨김여부
					//,size:100					//파이 차트 크기
				}
				*/
				//스캐터차트 속성
				/*
				scatter:{
					dashStyle:"solid"						//선유형 "solid,shortDash,shortDot,shortDashDot,shortDashDotDot,dot,dash,longDash,dashDot,longDashDot,longDashDotDot"
					//차트 데이타 라벨 설정
					,dataLabels: {
						enabled:true						//데이타 라벨 사용여부
						//,align:"center"					//정렬 설정 ( left, center, right )
						//,backgroundColor: "#ffffff"		//배경색상 설정
						//,borderColor: "#000000"			//테두리 색상
						//,borderRadius: 2					//테두리 둥근 정도
						//,borderWidth: 1					//테두리의 굵기
						//,color: "#000000"					//데이타 라벨 텍스트 색상
						//,crop:false						//데이타 라벨이 차트 영역 밖으로 나갔을때 자를지 여부( overflow가 none 인 경우 )
						//,format: "{y} 개"					//라벨 포멧 설정
						//,formatter: function(){			//함수로 포멧 설정
						//	return this.x + ">" + this.y;
						//}
						//,overflow:"justify"					//영역을 넘었을 때의 데이타 라벨 처리여부 justify(차트영역으로 내림 default), none(아무것도 안함)
						//,rotation: 0							//데이타 라벨 텍스트 회전
						//,style: {								//데이타 라벨 텍스트의 css 속성부여
						//	fontWeight:"bold"
						//	,color:"#1f1f1f"
						//}
						//,x: 0									//데이타 라벨 x축 이동
						//,y: -6								//데이타 라벨 y축 이동
						//,zIndex: 6							//데이타 라벨 zindex
					}
					//,lineWidth:2						//라인 넓이
					//,marker : {							//Marker
					//	enabled : true
					//	,symbol : "circle"				//"circle", "square", "diamond", "triangle" and "triangle-down"
					//}
					//,negativeColor: "blue"				//음수일때 색상
					//,showInLegend: true					//범례 표시 여부
					//,visible: true					//숨김여부
				}
				*/
				//시리즈 속성

				series:{
					connectNulls:true						//값이 null 인경우 연결 여부
					,dashStyle:"solid"						//선유형 "solid,shortDash,shortDot,shortDashDot,shortDashDotDot,dot,dash,longDash,dashDot,longDashDot,longDashDotDot"
					//차트 데이타 라벨 설정
					,dataLabels: {
						enabled:true						//데이타 라벨 사용여부
						//,align:"center"					//정렬 설정 ( left, center, right )
						//,backgroundColor: "#ffffff"		//배경색상 설정
						//,borderColor: "#000000"			//테두리 색상
						//,borderRadius: 2					//테두리 둥근 정도
						//,borderWidth: 1					//테두리의 굵기
						//,color: "#000000"					//데이타 라벨 텍스트 색상
						//,crop:false						//데이타 라벨이 차트 영역 밖으로 나갔을때 자를지 여부( overflow가 none 인 경우 )
						//,format: "{y} 개"					//라벨 포멧 설정
						//,formatter: function(){			//함수로 포멧 설정
						//	return this.x + ">" + this.y;
						//}
						//,overflow:"justify"					//영역을 넘었을 때의 데이타 라벨 처리여부 justify(차트영역으로 내림 default), none(아무것도 안함)
						//,rotation: 0							//데이타 라벨 텍스트 회전
						//,style: {								//데이타 라벨 텍스트의 css 속성부여
						//	fontWeight:"bold"
						//	,color:"#1f1f1f"
						//}
						//,x: 0									//데이타 라벨 x축 이동
						//,y: -6								//데이타 라벨 y축 이동
						//,zIndex: 6							//데이타 라벨 zindex
					}
					//,lineWidth:2						//라인 넓이
					//,marker : {							//Marker
					//	enabled : true
					//	,symbol : "circle"				//"circle", "square", "diamond", "triangle" and "triangle-down"
					//}
					//,negativeColor: "blue"				//음수일때 색상
					//,showInLegend: true					//범례 표시 여부
					//,stacking: null					//차트 스택킹 null, normal, percent
					//,visible: true					//숨김여부
				}
			}
		},1);

		myChart.setOptions({
			//7. x축 설정
			xAxis: {
				title:{				//x축 제목설정
					text:"x축 제목"
				}
				//,categories:null 			//x축 라벨 텍스트 배열
				//,max: null					//max값 설정
				//,min: null					//min값 설정
				//,opposite: false			//x축 이번인지 설정 ( true 시에는 반대편 x축)
				//,plotBands: [{ 				//특정 구간에 색상
				//	color: '#222222',
				//	from: 0.1,				//시작위치
				//	to: 1.1,				//종료위치
				//	label: {
				//		text: 'Plot band',			//텍스트
				//		rotation: 90,				//텍스트 회전
				//		textAlign: 'left'			//정렬
				//	}
				//}]
				//,tickColor: "#C0D0E0"			//간격자 색상
				,tickInterval: 1				//x축 텍스트 간격
				//,tickLength: 5					//tick 길이
				//,tickWidth: 1
			},
			//8. y축 설정
			yAxis: {
				title:{				//y축 제목설정
					enabled:true
					,text:"y축 제목"
					// ,style:{			//css 입력
					// 	color: '#6D869F',
					// 	fontWeight: 'bold'
					// }
				}
				// ,gridLineColor: "#C0C0C0"			//그리드 색상
				// ,gridLineDashStyle: "Solid"		//그리드 선 종류
				// ,gridLineWidth: 1				//그리드 선 넓이
				// ,labels: {						//라벨 설정
				// 	align: "right"
				// 	,enabled: true
				// 	,format: '{value} km'		//포멧 설정(formatter와 format은 하나만)
				// 	,rotation: 0
				// 	//,formatter: function(){		//함수 설정	(formatter와 format은 하나만)
				// 		//return this.value;
				// 	//}
				// 	,style:{
				// 		color: '#6D869F',
				// 		fontWeight: 'bold'
				// 	}
				// ,}
				// ,lineColor: "#C0D0E0"				//라인색상
				// ,lineWidth: 0						//라인 넓이
				// ,max: null					//최대값
				// ,min: null					//최소값
				// ,minorGridLineColor: "#E0E0E0"					//작은 단위 그리드 색상
				// ,minorGridLineDashStyle: "Solid"				//작은 단위 그리드 선 스타일
				// ,minorGridLineWidth: 1							//작은 단위 그리드 선 넓이
				// ,minorTickInterval: null						//작은 단위 간격
				// ,offset: 0								//축과 차트 데이타 영역과의 간격
				// ,opposite: false					//반대편 Y축 여부
				// ,tickInterval: 100						//단위 간격
			}
		}, {
			append: true
		});
	}
	function show2(){

		chartInit();


		var pparam = {
			datadirection:"horizontal",
			datarowcol:mySheet.getDataRows(),
			legendseriesname:mySheet.getDataRows().map(function(r){return r["uName"]}),
			legendtitle:"",
			startdatarowcol:"KOR",
			enddatarowcol:"MATH",
			labelrowcol:mySheet.getHeaderRows()[0],
			startlabelrowcol:"KOR",
			endlabelrowcol:"MATH",
			labeldirection:"horizontal"
		};
		SHEET2CHART(mySheet,myChart,pparam);
	}
	function show(){
		createIBChart("myChart", "myChart", {
			width: "100%",
			height: "275px"
		});

		chartInit();
		//=================================
		//9-2. URL로 부터 가져오기
		myChart.doSearch("xml/chartdata.xml", {
			append: true
		});		//막대 차트

		// myChart.doSearch("xml/chartdata2.xml", {
		// 	append: true
		// });		//파이 차트
	}
</script>
<body style="overflow-y:auto">
	<div class="page_title">
		<span><a class="closeDepth" href="#">closeDepth</a></span>
		<span class="title color_sheet">차트 템플릿  > <b>기본 템플릿</b></span>
	</div>

	<div class="main_content">
		<div class="exp_product">
			차트의 다양한 기능을 설정해 봅니다.
			<p style="color:orange">제품 소스에서 다양한 옵션내용을 수정해 보며, 기능을 확인해 보세요.</p>
		</div>
		<p class="subtit_chart">기능 버튼</p>
		<div class="ib_function2 border_chart">
			<table class="ib_column2">
				<tr>
					<th class="tit">차트 그리기</th>
					<td class="r20">
						<a class="f2_btn_white btn_chart" onclick="show()">그리기</a>
					</td>

					<th class="tit">시트연동해서 그리기</th>
					<td class="r20">
						<a class="f2_btn_white btn_chart" onclick="show2()">그리기</a>
					</td>
				</tr>
			</table>
		</div>

		<p class="subtit_chart">IB Chart</p><br/>
		<div class="ib_product">
			<div id="myChart"></div>
		</div>
		<p class="subtit_chart">IB Sheet 연동</p><br/>
		<div id="sheetDiv" class="ib_product" style="width:500px;height:300px">
		</div>

	</div>
</body>
</html>